/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.incident.HmcIncident;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.problem.ProblemFactory;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.domain.AnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;

public abstract class CommonDataAnalysisRoutine
extends CommonServiceAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPACDART";
    private static final String TRACE_MASKF = "XPACDARF";
    private static final String TRACE_MASKD = "XPACDARD";
    private static final boolean UNIT_TEST = true;
    protected CommonServiceIncident anIncident = null;

    protected AnalysisDomain getEventDomain(CommonDataEvent theEvent) {
        Trace.trace(TRACE_MASKF, "event domain: " + theEvent.getDomainId().getDID());
        return (AnalysisDomain)((Object)DomainManager.getDomainManager().get(theEvent.getDomainId()));
    }

    protected void processEvent(CommonDataEvent theEvent) {
        Trace.trace(TRACE_MASKD, "--> processEvent");
        CommonProblem aProblem = null;
        try {
            aProblem = this.instantiateProblem(theEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-- processEvent: couldn't create problem: ");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        if (aProblem == null) {
            Trace.trace(TRACE_MASKT, "<-- processEvent: no problem created");
            return;
        }
        try {
            this.anIncident = this.instantiateIncident(theEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-- processEvent: couldn't create incident: ");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        if (this.anIncident == null) {
            Trace.trace(TRACE_MASKT, "<-- processEvent: no incident created");
            return;
        }
        this.anIncident.setProblem(aProblem);
    }

    protected CommonProblem instantiateProblem(CommonDataEvent theEvent) throws HException {
        PASystem system = theEvent.getSystem();
        CommonProblem problem = null;
        try {
            ProblemFactory pf = (ProblemFactory)ServiceInterfaces.getFactory(system, "ProblemFactory");
            problem = (CommonProblem)pf.createProblem(system);
            problem.setPrimaryDataEvent(theEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> instantiateProblem: Exception encountered: ");
            Trace.trace(TRACE_MASKT, e);
            if (!(e instanceof HException)) {
                throw new HException(e);
            }
            throw (HException)e;
        }
        return problem;
    }

    protected CommonServiceIncident instantiateIncident(CommonDataEvent theEvent) throws HException {
        return new HmcIncident();
    }

    protected static void setMessages(CommonProblem problem, ArrayList messages) {
        if (messages != null && messages.size() >= 1) {
            problem.addProblemStatement((LocalizableText)new BaseMessageText("XPA" + messages.get(0)));
        }
        if (messages != null && messages.size() >= 2) {
            problem.addRepairImpactStatement((LocalizableText)new BaseMessageText("XPA" + messages.get(1)));
        }
        if (messages != null && messages.size() >= 3) {
            problem.addCorrectiveActionStatement((LocalizableText)new BaseMessageText("XPA" + messages.get(2)));
        }
        if (messages != null && messages.size() > 3) {
            for (int i = 3; i < messages.size(); ++i) {
                problem.addProblemStatement((LocalizableText)new BaseMessageText("XPA" + messages.get(i)));
            }
        }
    }

    protected void reportIncident(CommonDataEvent event, CommonServiceIncident anIncident, CommonServiceAREvent timeoutEvent, int timeoutValue) {
        Trace.trace(TRACE_MASKD, "--> reportIncident()");
        timeoutEvent.setSystem(event.getSystem());
        timeoutEvent.setIncidentPoolId(event.getIncidentPoolId());
        anIncident.setTimerEvent(timeoutEvent);
        Boolean delayed = (Boolean)event.getMetaData().getMeta("pdc_DELAYED_LOG");
        if (delayed != null) {
            anIncident.getProblem().setDelayed(delayed);
        }
        if (this.eventManager == null) {
            Trace.trace(TRACE_MASKD, ">>>>>>> event manager is NULL!!!!!!!!");
        }
        anIncident.setEventManager(this.eventManager);
        anIncident.schedule(timeoutValue * 1000);
        this.getPendingIncidentPool(event.getIncidentPoolId()).add(anIncident);
        Trace.trace(TRACE_MASKD, "<-- reportIncident()");
    }
}

